/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.TypeConverter;

public class FiveVoltSenseDataBlock
extends DataBlock {
    private long m_timeStamp;
    private int m_connectorId;
    private int m_connectorNumber;
    private int m_status;
    private boolean m_valid = false;

    public FiveVoltSenseDataBlock() {
        this.m_timeStamp = 0L;
        this.m_connectorId = 0;
        this.m_connectorNumber = 0;
        this.m_status = 0;
        this.m_valid = false;
    }

    public FiveVoltSenseDataBlock(Integer[] integerArray) {
        this.m_timeStamp = TypeConverter.composeLong(integerArray, 7);
        this.m_connectorId = integerArray[11];
        this.m_connectorNumber = integerArray[12];
        this.m_status = integerArray[13];
        if (this.m_status == 0 || this.m_status == 1) {
            this.m_valid = true;
        }
    }

    public long getTimestamp() {
        return this.m_timeStamp;
    }

    public boolean isError() {
        return !this.m_valid;
    }

    public String getType() {
        return "<html><b>5-Volt Sense</b></html>";
    }

    public String getSummary() {
        if (!this.m_valid) {
            return "Invalid Packet Data";
        }
        if (this.m_status == 1) {
            return "5-Volts Turned ON";
        }
        return "5-Volts Turned OFF";
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.m_valid) {
            return "No Details";
        }
        stringBuffer.append("Timing Information\n");
        stringBuffer.append("------------------\n");
        stringBuffer.append("     Time since last reset: ");
        stringBuffer.append(TypeConverter.getTimestampString(this.m_timeStamp * 100L));
        stringBuffer.append("\n\nNOTE: The timing (sequencing) of this packet relative to other packets");
        stringBuffer.append("\n      in the above Packet list is only approximate.\n\n");
        if (this.m_status == 1) {
            stringBuffer.append("The analyzer noted a low-to-high transition on the 5-Volt line\n");
        } else {
            stringBuffer.append("The analyzer noted a high-to-low transition on the 5-Volt line\n");
        }
        stringBuffer.append("on interface: " + this.getSourceName());
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public String getSourceName() {
        String string;
        switch (this.m_connectorId) {
            case 1: {
                string = "HDMI Output #" + this.m_connectorNumber;
                break;
            }
            case 2: {
                string = "HDMI Input #" + this.m_connectorNumber;
                break;
            }
            case 3: {
                string = "DVI Output #" + this.m_connectorNumber;
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public String getDirection() {
        return "";
    }

    public short getSource() {
        return 5;
    }

    public boolean isEvent() {
        return true;
    }

    public boolean isI2C() {
        return false;
    }

    public boolean isCEC() {
        return false;
    }

    public boolean isHDCP() {
        return false;
    }

    public boolean isDDCCI() {
        return false;
    }

    public boolean isEDID() {
        return false;
    }

    public boolean isLT() {
        return false;
    }

    public int getSourceID() {
        return 0;
    }
}

